
#version 430 core

layout(points) in;
layout(triangle_strip) out;
layout(max_vertices = 4) out;

//inputs
layout (location = 0) in int g_Type[];
layout (location = 1) in float g_Age[];
layout (location = 2) in vec3 g_WorldPos[];
layout (location = 3) in vec4 g_AuxVecOne[];
layout (location = 4) in vec3 g_WorldVel[];

//outputs

layout (location = 0) out flat int f_Type;
layout (location = 1) out float f_Age;
layout (location = 2) out vec2 f_gCoord;
layout (location = 3) out vec3 f_gWorldPos;
layout (location = 4) out vec4 f_AuxVecOne;
layout (location = 5) out flat int f_OwnerID;

uniform mat4 mVP;

uniform vec3 vQuad1;
uniform vec3 vQuad2;

uniform mat4 worldTransform;
uniform int NULLPLANET;
uniform int currentPlanet;

layout(rgba16f, binding = 2) uniform readonly restrict image2D planetInputTex;

void main()
{

		float particleSize = 8.0f;

		int particleType = g_Type[0];
		int particlePlanet = int(g_AuxVecOne[0].w);
		int particleOwner = int(g_AuxVecOne[0].x);
		vec3 vPosOld;

		switch(particlePlanet){
			case(0): 
				vPosOld = (worldTransform * vec4(gl_in[0].gl_Position.xyz, 1.0)).xyz;
				break;
			default:

				if(particlePlanet == currentPlanet){
					vPosOld = vec4(gl_in[0].gl_Position.xyz, 1.0).xyz;
					break;
				}else{
					int planetIndex = particlePlanet - (NULLPLANET + 1);
					mat4 planetTransform;
					planetTransform[0] = vec4(imageLoad(planetInputTex, ivec2(0, planetIndex)));
					planetTransform[1] = vec4(imageLoad(planetInputTex, ivec2(1, planetIndex)));
					planetTransform[2] = vec4(imageLoad(planetInputTex, ivec2(2, planetIndex)));
					planetTransform[3] = vec4(imageLoad(planetInputTex, ivec2(3, planetIndex)));
					vPosOld = (worldTransform * planetTransform * vec4(gl_in[0].gl_Position.xyz, 1.0)).xyz;
					break;
				}

		}

		switch(particleType){
			case(1): 
				particleSize = 8.0f;
				break;
			case(2): 
				particleSize = 16.0f;
				break;
			case(3):
				particleSize = 0.2 + pow(g_Age[0] / 1.0, 2.0) * 1.2;
				break;
			case(4):
				particleSize = g_AuxVecOne[0].x; 
				break;
			case(5):
				particleSize = 2.0f;
				break;
			case(6):
				particleSize = 4.0f; 
				break;
			case(7):
				particleSize = 0.2f;
				particleOwner = particlePlanet - (NULLPLANET);
				break;
			case(8):
				particleSize = 0.25f; 
				break;
			case(9):
				particleSize = 10.0f / (0.1f + g_Age[0]); 
				break;
			case(11):
				particleSize = 0.4; 
				break;
			case(12): //fireworks rocket
				particleSize = 0.2 * (1.0 + g_Age[0]); 
				break;
			case(13): //fireworks explosion
				particleSize = 0.7 * (1.0 - g_Age[0] / 1.5f); 
				break;
			default:
				particleSize = 0.0f;
				break;
		}


		if(particleSize > 0.0){
      
		vec3 vPos = vPosOld+(-vQuad1-vQuad2) * particleSize;
		gl_Position = mVP*vec4(vPos, 1.0);
		f_Type = particleType;
		f_Age = g_Age[0];
		f_gCoord = vec2(-1,-1);
		f_gWorldPos = g_WorldPos[0];
		f_AuxVecOne = g_AuxVecOne[0];
		f_OwnerID = particleOwner;
		EmitVertex();
  
		vPos = vPosOld+(-vQuad1+vQuad2) * particleSize;
		gl_Position = mVP*vec4(vPos, 1.0);
		f_Type = particleType;
		f_Age = g_Age[0];
		f_gCoord = vec2(-1,1);
		f_gWorldPos = g_WorldPos[0];
		f_AuxVecOne = g_AuxVecOne[0];
		f_OwnerID = particleOwner;
		EmitVertex();
  
		vPos = vPosOld+(vQuad1-vQuad2) * particleSize;
		gl_Position = mVP*vec4(vPos, 1.0);
		f_Type = particleType;
		f_Age = g_Age[0];
		f_gCoord = vec2(1,-1);
		f_gWorldPos = g_WorldPos[0];
		f_AuxVecOne = g_AuxVecOne[0];
		f_OwnerID = particleOwner;
		EmitVertex();
  
		vPos = vPosOld+(vQuad1+vQuad2) * particleSize;
		gl_Position = mVP*vec4(vPos, 1.0);
		f_Type = particleType;
		f_Age = g_Age[0];
		f_gCoord = vec2(1,1);
		f_gWorldPos = g_WorldPos[0];
		f_AuxVecOne = g_AuxVecOne[0];
		f_OwnerID = particleOwner;
		EmitVertex();
   
		EndPrimitive();
	}
}
